/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import test.Food;
import test.Game;
import test.Snake;

public class Graphics
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Timer t = new Timer(100, this);
    public String state;
    private Snake s;
    private Food f;
    private Game game;
    private int w = 30;
    private int h = 30;
    private int d = 20;

    public Graphics(Game g) {
        this.t.start();
        this.state = "START";
        this.game = g;
        this.s = g.getPlayer();
        this.f = g.getFood();
        this.addKeyListener(g);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public void paintComponent(java.awt.Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        g2d.fillRect(0, 0, this.w * this.d + 5, this.h * this.d + 5);
        if (this.state == "START") {
            g2d.setColor(Color.white);
            g2d.drawString("Press Any Key", this.w / 2 * this.d - 40, this.h / 2 * this.d - 20);
        } else if (this.state == "RUNNING") {
            g2d.setColor(Color.red);
            g2d.fillRect(this.f.getX() * this.d, this.f.getY() * this.d, this.d, this.d);
            g2d.setColor(Color.green);
            for (Rectangle r : this.s.getBody()) {
                g2d.fill(r);
            }
        } else {
            g2d.setColor(Color.white);
            g2d.drawString("Your Score: " + (this.s.getBody().size() - 3), this.w / 2 * this.d - 40, this.h / 2 * this.d - 20);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
        this.game.update();
    }
}

