/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import javax.swing.JFrame;
import test.Food;
import test.Graphics;
import test.Snake;

public class Game
implements EventListener,
KeyListener {
    private Snake player;
    private Food food;
    private Graphics graphics;
    public static final int width = 30;
    public static final int height = 30;
    public static final int dimension = 20;
    private JFrame window = new JFrame();

    public Game() {
        this.player = new Snake();
        this.food = new Food(this.player);
        this.graphics = new Graphics(this);
        this.window.add(this.graphics);
        this.window.setTitle("Snake");
        this.window.setSize(602, 604);
        this.window.setVisible(true);
        this.window.setDefaultCloseOperation(3);
    }

    public void start() {
        this.graphics.state = "RUNNING";
    }

    public void update() {
        if (this.graphics.state == "RUNNING") {
            if (this.foodCollision()) {
                this.player.grow();
                this.food.random_spawn(this.player);
            } else if (this.wallCollision() || this.selfCollision()) {
                this.graphics.state = "END";
            } else {
                this.player.move();
            }
        }
    }

    private boolean wallCollision() {
        return this.player.getX() < 0 || this.player.getX() >= 600 || this.player.getY() < 0 || this.player.getY() >= 600;
    }

    private boolean foodCollision() {
        return this.player.getX() == this.food.getX() * 20 && this.player.getY() == this.food.getY() * 20;
    }

    private boolean selfCollision() {
        int i = 1;
        while (i < this.player.getBody().size()) {
            if (this.player.getX() == this.player.getBody().get((int)i).x && this.player.getY() == this.player.getBody().get((int)i).y) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.graphics.state == "RUNNING") {
            if (keyCode == 87) {
                this.player.up();
            } else if (keyCode == 83) {
                this.player.down();
            } else if (keyCode == 65) {
                this.player.left();
            } else {
                this.player.right();
            }
        } else {
            this.start();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public Snake getPlayer() {
        return this.player;
    }

    public void setPlayer(Snake player) {
        this.player = player;
    }

    public Food getFood() {
        return this.food;
    }

    public void setFood(Food food) {
        this.food = food;
    }

    public JFrame getWindow() {
        return this.window;
    }

    public void setWindow(JFrame window) {
        this.window = window;
    }
}

